<?php
/**
 * OTIMIZAÇÃO DE MEMÓRIA E BOTÃO VER TUDO EM TODAS AS SEÇÕES
 */
ini_set('memory_limit', '512M'); 
error_reporting(0); 

include "session.php";
include "config.php";
include "header.php";

function getApiData($url) {
    if (session_status() === PHP_SESSION_NONE) { session_start(); }
    $cacheKey = md5($url);
    if (isset($_SESSION['api_cache'][$cacheKey]) && (time() - ($_SESSION['api_cache_time'][$cacheKey] ?? 0) < 300)) {
        return $_SESSION['api_cache'][$cacheKey];
    }
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) Otimizado');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip"); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode !== 200 || !$response) return [];
    $decodedData = json_decode($response, true);
    if (!is_array($decodedData)) return [];
    $_SESSION['api_cache'][$cacheKey] = $decodedData;
    $_SESSION['api_cache_time'][$cacheKey] = time();
    return $decodedData;
}

$get_dns = $get_dns ?? '';
$username = $username ?? '';
$password = $password ?? '';

// Categorias
$categoriesUrl = $get_dns . "/player_api.php?username=$username&password=$password&action=get_vod_categories";
$movie_categories = getApiData($categoriesUrl);
$initial_sections = array_slice($movie_categories, 0, 4);
$later_sections = array_slice($movie_categories, 4);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0, viewport-fit=cover" />
    <title>WEB PLAYER</title>
    <link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap" rel="stylesheet" />
    <style>
        :root { --primary: #e50914; --bg-dark: #0a0a0c; --glass: rgba(255, 255, 255, 0.05); --glass-border: rgba(255, 255, 255, 0.12); }
        * { box-sizing: border-box; }
        body { margin: 0; background: var(--bg-dark); color: #fff; font-family: 'Montserrat', sans-serif; overflow-x: hidden; }

        #player-modal { display: none; position: fixed; inset: 0; background: #000; z-index: 999999; flex-direction: column; justify-content: center; align-items: center; }
        .plyr-container { width: 100%; max-width: 1200px; aspect-ratio: 16 / 9; background: #000; }
        .close-player { position: absolute; top: 20px; right: 20px; z-index: 1000001; background: var(--primary); color: #fff; border: none; padding: 10px 20px; border-radius: 50px; cursor: pointer; font-weight: bold; }

        .section-header { display: flex; justify-content: space-between; align-items: center; padding: 0 5%; margin-top: 30px; }
        .section-title { font-size: 1rem; font-weight: 700; border-left: 4px solid var(--primary); padding-left: 12px; }
        .btn-view-all { color: var(--primary); text-decoration: none; font-size: 0.75rem; font-weight: 800; border: 1px solid var(--primary); padding: 4px 12px; border-radius: 20px; transition: 0.3s; }
        .btn-view-all:hover { background: var(--primary); color: #fff; }

        .grid-container { display: flex; gap: 12px; overflow-x: auto; padding: 15px 5%; scrollbar-width: none; }
        .grid-container::-webkit-scrollbar { display: none; }
        .grid-item { flex: 0 0 130px; cursor: pointer; transition: 0.3s; }
        .grid-item:hover { transform: translateY(-5px); }
        .grid-item img { width: 100%; height: 190px; object-fit: cover; border-radius: 12px; border: 1px solid var(--glass-border); }
        .grid-item p { font-size: 0.75rem; margin-top: 8px; text-align: center; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }

        @media (max-width: 768px) {
            .grid-item { flex: 0 0 120px; }
            .grid-item img { height: 170px; }
        }
    </style>
</head>
<body>

<div id="player-modal">
    <button class="close-player" onclick="stopVideo()">✕ FECHAR</button>
    <div class="plyr-container">
        <video id="plyr-player" playsinline controls></video>
    </div>
</div>

<div id="php-sections">
    <?php foreach ($initial_sections as $value): 
        $cid = $value["category_id"];
    ?>
        <div class="section-header">
            <h2 class="section-title"><?php echo htmlspecialchars($value["category_name"]); ?></h2>
            <a href="movies.php?id=<?php echo $cid; ?>" class="btn-view-all">VER TUDO</a>
        </div>
        <div class="grid-container">
            <?php
            $items = getApiData($get_dns . "/player_api.php?username=$username&password=$password&action=get_vod_streams&category_id=$cid&limit=15");
            foreach ($items as $item):
                $ext = $item["container_extension"] ?? "mp4";
                $stream_url = "$get_dns/movie/$username/$password/{$item['stream_id']}.$ext";
                $img = $item["stream_icon"] ?: "https://i.imgur.com/Mn7aXQD.jpg";
            ?>
                <div class="grid-item" onclick="startVideo('<?= $stream_url ?>')">
                    <img src="<?= $img ?>" loading="lazy" onerror="this.src='https://i.imgur.com/Mn7aXQD.jpg';">
                    <p><?= htmlspecialchars($item["name"]) ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
</div>

<div id="lazy-sections"></div>

<script src="https://cdn.plyr.io/3.7.8/plyr.polyfilled.js"></script>
<script>
    const player = new Plyr('#plyr-player', { ratio: '16:9' });

    function startVideo(url) {
        const modal = document.getElementById('player-modal');
        player.source = { type: 'video', sources: [{ src: url, type: 'video/mp4' }] };
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
        player.play();
    }

    function stopVideo() {
        document.getElementById('player-modal').style.display = 'none';
        document.body.style.overflow = 'auto';
        player.stop();
    }

    let laterSections = <?php echo json_encode($later_sections); ?>;
    let currentIdx = 0;
    let isFetching = false;

    async function loadMore() {
        if (isFetching || currentIdx >= laterSections.length) return;
        isFetching = true;
        
        const section = laterSections[currentIdx];
        
        // ADICIONADO: O link "VER TUDO" agora é gerado aqui também para o scroll infinito
        const html = `
            <div class="section-header">
                <h2 class="section-title">${section.category_name}</h2>
                <a href="movies.php?id=${section.category_id}" class="btn-view-all">VER TUDO</a>
            </div>
            <div class="grid-container" id="grid_${section.category_id}">Carregando filmes...</div>
        `;
        
        document.getElementById('lazy-sections').insertAdjacentHTML('beforeend', html);

        try {
            const res = await fetch(`<?php echo $get_dns; ?>/player_api.php?username=<?php echo $username; ?>&password=<?php echo $password; ?>&action=get_vod_streams&category_id=${section.category_id}&limit=12`);
            const data = await res.json();
            const grid = document.getElementById(`grid_${section.category_id}`);
            
            if (data.length === 0) {
                grid.innerHTML = "<p style='padding-left:5%; opacity:0.5'>Nenhum filme nesta categoria.</p>";
            } else {
                grid.innerHTML = data.map(m => `
                    <div class="grid-item" onclick="startVideo('<?php echo $get_dns; ?>/movie/<?php echo $username; ?>/<?php echo $password; ?>/${m.stream_id}.${m.container_extension || 'mp4'}')">
                        <img src="${m.stream_icon || 'https://i.imgur.com/Mn7aXQD.jpg'}" onerror="this.src='https://i.imgur.com/Mn7aXQD.jpg'">
                        <p>${m.name}</p>
                    </div>`).join('');
            }
        } catch (e) {
            console.error("Erro ao carregar seção:", e);
        }
        
        currentIdx++;
        isFetching = false;
    }

    // Gatilho para carregar mais ao chegar no fim da página
    window.addEventListener('scroll', () => {
        if (window.innerHeight + window.scrollY >= document.body.offsetHeight - 800) {
            loadMore();
        }
    });
</script>
</body>
</html>